/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.util.QueryFilePath;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;

public class FileControl {
    private static final String TRACE_MASKT = "XDFCQFPT";
    private static final String TRACE_MASKD = "XDFCQFPD";
    private static final String TRACE_MASKF = "XDFCQFPF";
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "DFCQryPath");
    private static final short ERRID_0410 = 1040;
    private static final short ERRID_0411 = 1041;
    private static final short ERRID_0412 = 1042;
    private static final short ERRID_0413 = 1043;
    private static final short ERRID_0414 = 1044;
    private static final short ERRID_0415 = 1045;

    public static void readDefFile(String defFn, ArrayList dfcMask, ArrayList dfcPath) throws FileNotFoundException, Throwable {
        String str;
        BufferedReader in;
        try {
            Trace.trace(TRACE_MASKF, "DFC query file path trm file = [" + defFn + "]");
            in = new BufferedReader(new FileReader(defFn));
        }
        catch (FileNotFoundException fnfe) {
            HException hexc = new HException(fnfe);
            new FrameworkLog(_logInfo, 1040, hexc).log();
            throw hexc;
        }
        catch (Throwable e) {
            HException hexc = new HException(e);
            new FrameworkLog(_logInfo, 1041, e).log();
            throw e;
        }
        int index = 0;
        while ((str = in.readLine()) != null) {
            if (fnfe.length() == 0) {
                Trace.trace(TRACE_MASKF, "Len of a line from DFCFilePathTrmFile is 0");
                continue;
            }
            if (fnfe.substring(0, 1).equals("#")) continue;
            str = fnfe.trim();
            index = str.indexOf(32);
            if (index == -1) {
                in.close();
                Trace.trace(TRACE_MASKF, "DFC qry path file = [" + defFn + "] has an error");
                Trace.trace(TRACE_MASKF, "DFC qry path data in error =[" + str + "]");
                HException hexc = new HException("DFC qry path file=[" + defFn + "]. Its contents has an error. Error line=[" + str + "]");
                new FrameworkLog(_logInfo, 1042, hexc).log();
                throw hexc;
            }
            dfcMask.add(str.substring(0, index).trim());
            String path = str.substring(index).trim();
            index = path.indexOf(32);
            if (index != -1) {
                String extra = path.substring(index).toUpperCase();
                path = path.substring(0, index).trim();
                if (extra.indexOf(67) != -1) {
                    String dirPath = path.substring(0, 1).equals("*") ? FileControl.useDefMask(defFn, path) : path;
                    Trace.trace(TRACE_MASKF, "Path =[" + dirPath + "] has directory creation enabled.");
                    File dir = new File(dirPath);
                    if (dir.exists()) {
                        Trace.trace(TRACE_MASKF, "Path =[" + dirPath + "] already exists.");
                    } else {
                        dir.mkdirs();
                        Trace.trace(TRACE_MASKF, "Path =[" + dirPath + "] has been created.");
                    }
                }
            }
            dfcPath.add(path);
        }
        in.close();
    }

    public static String getFilePath(String defFn, String fn, ArrayList dfcMask, ArrayList dfcPath) throws HException {
        QueryFilePath qryFilePath = new QueryFilePath(fn, dfcMask, dfcPath);
        String filePath = qryFilePath.getFilePath();
        if (filePath.length() == 0) {
            Trace.trace(TRACE_MASKF, "Error: No path found for the file =[" + fn + "].");
            HException hexc = new HException("No path found for the file =[" + fn + "]");
            new FrameworkLog(_logInfo, 1045, hexc).log();
            throw hexc;
        }
        if (filePath.substring(0, 1).equals("*")) {
            filePath = FileControl.useDefMask(defFn, filePath);
        }
        Trace.trace(TRACE_MASKF, "This is the filePath=[" + filePath + "] for the file=[" + fn + "]");
        filePath = filePath.replace('/', File.separatorChar);
        return filePath;
    }

    private static String useDefMask(String defFn, String filePath) throws HException {
        int index = defFn.lastIndexOf("/");
        if (index == -1) {
            Trace.trace(TRACE_MASKF, "Error: No path specified for the DFC query path file =[" + defFn + "]");
            HException hexc = new HException("No path specified for the DFC query path file=[" + defFn + "]");
            new FrameworkLog(_logInfo, 1044, hexc).log();
            throw hexc;
        }
        filePath = filePath.length() > 1 && filePath.substring(1, 2).equals("/") ? defFn.substring(0, index) + filePath.substring(1) : defFn.substring(0, index + 1) + filePath.substring(1);
        return filePath;
    }
}

